/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.drive.TapeDriveHandler;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class P00DriveHandler
extends TapeDriveHandler {
    @Override
    public void mount(byte[] bytes) {
        this.imageType = 1;
        this.bytes = bytes;
        this.tapePosition = 0;
        byte[] buffer = this.readTapeData(8);
        if (!new String(buffer).startsWith("C64")) {
            throw new RuntimeException("Not a valid .p00 file!");
        }
        this.label = ".P00 FILE";
    }

    @Override
    public Enumeration directoryElements() {
        return new Enumeration(){
            private int retrieved = 0;

            @Override
            public boolean hasMoreElements() {
                return this.retrieved < 1;
            }

            public Object nextElement() {
                if (this.retrieved > 0) {
                    throw new NoSuchElementException("Tried to access past end of directory");
                }
                P00DriveHandler.this.gotoTapePosition(8);
                byte[] buffer = P00DriveHandler.this.readTapeData(20);
                int fileType = 130;
                int startAddress = (buffer[18] & 0xFF) + (buffer[19] & 0xFF) * 256;
                int offset = P00DriveHandler.this.tapePosition;
                String filename = P00DriveHandler.this.readC64Filename(buffer, 0, 16);
                ++this.retrieved;
                return new C64FileEntry(filename, 130, startAddress, offset);
            }
        };
    }
}

